/**
* \file: AditCoreSurrogate.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Proxy for Baidu core, initializes and deinitializes connection.
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <memory>
#include <AditCoreSurrogate.h>
#include "adit_bdcl.h"

namespace adit { namespace bdcl {

using std::unique_ptr;

AditCoreSurrogate::AditCoreSurrogate(IAditBaiduCoreCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer)
{
    (void)inCallbackDealer;
    mBackend = move(unique_ptr<abdcl>(new abdcl()));
    mBackend->registerAditBaiduCoreCallbacks(inCallbacks);
}

AditCoreSurrogate::~AditCoreSurrogate() { }

bdclInitStatus AditCoreSurrogate::initialize(int aoapAccessoryId, int aoapDeviceId)
{
    return mBackend->bdclInit(aoapAccessoryId, aoapDeviceId);
}

bdclInitStatus AditCoreSurrogate::initialize(const char* wFile, const char* rFile)
{
    return mBackend->bdclInit(wFile, rFile);
}

void AditCoreSurrogate::abortInitialization()
{
    mBackend->bdclAbortInit();
}

void AditCoreSurrogate::teardown()
{
    mBackend->teardown();
}

void AditCoreSurrogate::setProtocolStatusTimeout(uint16_t inTimeout)
{
    mBackend->setProtocolStatusTimeOut(inTimeout);
}

void AditCoreSurrogate::setCarLifeStaticsInfo(S_STATISTICS_INFO* inInfo)
{
    mBackend->setCarLifeStaticsInfo(inInfo);
}

} } /* namespace adit { namespace bdcl */
